//
//  MCReportLocator.h
//  MCReporting
//
//  Created by Alykhan Jetha on 11/11/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MCReportLocator : NSObject {
	NSMutableArray *searchPaths;
	NSMutableArray *extensions;

}

+ (void)registerReportFileExtension:(NSString *)anExtension;
+ (NSArray *)registeredReportFileExtensions;

+ (MCReportLocator *)defaultReportLocator;
+ (MCReportLocator *)reportLocatorWithUserReportsOnly;

// return ~/Library/Application Support/<app name>/Templates
+ (NSString *)preferredStoragePath;
// user defaults MCReportSharedStoragePath - may return nil
+ (NSString *)sharedStoragePath;


- (NSMutableArray *)searchPaths;
- (void)setSearchPaths:(NSMutableArray *)aSearchPaths;

- (NSMutableArray *)extensions;
- (void)setExtensions:(NSMutableArray *)anExtensions;
- (void)addToExtensions:(NSString *)anExtension;

	// does not search subfolders
- (void)addSearchablePath:(NSString *)folderPath;
- (void)addSearchablePathsFromBundle:(NSBundle *)aBundle;

- (NSArray *)allReportPaths;

// reads the info plist and returns only the ones that match (as filewrappers)
- (NSArray *)reportWrappersMatchingBehaviors:(NSArray *)behavs typeIdentifier:(NSString *)aName;
- (NSArray *)reportWrappersMatchingBehaviors:(NSArray *)behavs typeIdentifier:(NSString *)aName includeMergeKitTemplates:(BOOL)includeMerge;

// looks for report of behavior and ident, read them, applies the changes and saves the report. If any errors where encountered saving, it puts the details in the array of NSError. If the array is empty or nil, no errors occurred.
// the change array must contain dictionaries and each dictionary can have the following keys
//		originalKeyPath
//      newKeyPath
//      originalFormatterCode
//      newFormatterCode
//      displayName  (optional for tokens only)
//
// uses 'contains' in the keypath search and only replaces that part.
- (NSArray *)applyChanges:(NSArray *)changeList toUserReportWrappersMatchingBehaviors:(NSArray *)behavs typeIdentifier:(NSString *)aName;


@end
